#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64

// Declaration for SSD1306 display connected via I2C
#define OLED_RESET    -1
#define SCREEN_ADDRESS 0x3C  // Default I2C address for most OLEDs

Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

void setup() {
  // Initialize Serial (optional)
  Serial.begin(115200);

  // Initialize OLED
  if (!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) {
    Serial.println(F("SSD1306 allocation failed"));
    while (true); // Stop if failed
  }

  display.clearDisplay();
  
  // Set text properties
  display.setTextSize(2);       // Text size (1–3 recommended)
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0, 20);     // x = 0, y = 20

  display.print("Quad");
  display.setCursor(0, 45);
  display.print("Robotics");

  display.display();            // Push to screen
}

void loop() {
  // Nothing here – display shows static text
}
