#define IR_SENSOR_PIN 4   // Digital input from IR sensor
#define RED_PIN       25  // Red channel of RGB LED
#define GREEN_PIN     26  // Green channel of RGB LED

// PWM setup
const int PWM_FREQ = 5000;
const int PWM_RES  = 8;   // 8-bit (0–255)

void setup() {
  Serial.begin(115200);

  pinMode(IR_SENSOR_PIN, INPUT);

  // ESP32 core 3.x PWM attach
  ledcAttach(RED_PIN, PWM_FREQ, PWM_RES);
  ledcAttach(GREEN_PIN, PWM_FREQ, PWM_RES);
}

void loop() {
  int irValue = digitalRead(IR_SENSOR_PIN);

  Serial.print("IR Sensor: ");
  Serial.println(irValue);  // LOW = obstacle detected

  if (irValue == LOW) {
    // Obstacle detected → Red ON, Green OFF
    ledcWrite(RED_PIN, 255);
    ledcWrite(GREEN_PIN, 0);
  } else {
    // No obstacle → Green ON, Red OFF
    ledcWrite(RED_PIN, 0);
    ledcWrite(GREEN_PIN, 255);
  }

  delay(100);
}
