#define LDR_PIN  4     // Analog pin connected to LDR module output
#define RED_PIN  25    // PWM pin connected to Red pin of RGB LED

const int PWM_FREQ = 5000;
const int PWM_RESOLUTION = 8; // 8-bit resolution: 0–255

int threshold = 2000;  // Light threshold (0–4095). Above = dark

void setup() {
  Serial.begin(115200);

  // ESP32 core 3.x PWM setup
  ledcAttach(RED_PIN, PWM_FREQ, PWM_RESOLUTION);
}

void loop() {
  int lightLevel = analogRead(LDR_PIN);

  Serial.print("Light Level: ");
  Serial.println(lightLevel);

  if (lightLevel < threshold) {
    // Bright → OFF
    ledcWrite(RED_PIN, 0);
  } else {
    // Dark → ON
    ledcWrite(RED_PIN, 255);
  }

  delay(500);
}
