#define BUZZER_PIN     23
#define BUZZER_CHANNEL 0

// Notes in frequency (Hz)
int melody[] = {
  262, 294, 330, 349, 392, 440, 494, 523  // C4, D4, E4, F4, G4, A4, B4, C5
};

// Duration of each note (in ms)
int noteDurations[] = {
  400, 400, 400, 400, 400, 400, 400, 800
};

void setup() {
  ledcSetup(BUZZER_CHANNEL, 2000, 8);        // Init PWM (frequency here is placeholder)
  ledcAttachPin(BUZZER_PIN, BUZZER_CHANNEL);
}

void loop() {
  for (int i = 0; i < 8; i++) {
    int note = melody[i];
    int duration = noteDurations[i];

    ledcWriteTone(BUZZER_CHANNEL, note);     // Play the note
    delay(duration);                         // Hold it for note duration
    ledcWriteTone(BUZZER_CHANNEL, 0);        // Pause between notes
    delay(50);                               // Short pause between notes
  }

  delay(2000);  // Wait before repeating the melody
}
