#define LED_PIN     4       // GPIO pin connected to LED
#define POT_PIN     34      // GPIO pin connected to potentiometer

const int PWM_CHANNEL = 0;
const int PWM_FREQ = 5000;
const int PWM_RESOLUTION = 8;  // 8-bit resolution (0–255)

void setup() {
  Serial.begin(115200);

  // NEW ESP32 3.x PWM API
  ledcAttach(LED_PIN, PWM_FREQ, PWM_RESOLUTION);
}

void loop() {
  int potValue = analogRead(POT_PIN);               // 0–4095
  int brightness = map(potValue, 0, 4095, 255, 0);  // reverse mapping

  ledcWrite(LED_PIN, brightness);                   // NEW API

  Serial.print("Pot: ");
  Serial.print(potValue);
  Serial.print(" → Brightness: ");
  Serial.println(brightness);

  delay(10);
}
