#define LED_PIN 4
#define BUTTON_PIN 13

void setup() {
  pinMode(LED_PIN, OUTPUT);
  pinMode(BUTTON_PIN, INPUT_PULLUP);  // Use internal pull-up
  Serial.begin(9600);
}

void loop() {
  int buttonState = digitalRead(BUTTON_PIN);

  Serial.print("Button State: ");
  Serial.println(buttonState); // LOW when pressed, HIGH when released

  if (buttonState == LOW) {              // Button is pressed
    digitalWrite(LED_PIN, HIGH);         // Turn LED ON
  } else {
    digitalWrite(LED_PIN, LOW);          // Turn LED OFF
  }

  delay(100);
}
