#include <WiFi.h>
#include <WebServer.h>

// Wi-Fi credentials
const char* ssid = "YOUR_SSID";  // Replace with your wifi user name
const char* password = "YOUR_PASSWORD"; // replace with your wifi password

// Relay GPIOs
#define RELAY1 26
#define RELAY2 27

WebServer server(80);

// Track state of each relay
bool relay1State = false;
bool relay2State = false;

// HTML Page
const char index_html[] PROGMEM = R"rawliteral(
<!DOCTYPE html>
<html>
<head>
  <title>QUAD ROBOTICS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      font-family: Arial, sans-serif;
      text-align: center;
      background-color: #f9f9f9;
      padding: 20px;
    }
    h1 {
      color: #2c3e50;
      margin-bottom: 5px;
    }
    h4 {
      color: #7f8c8d;
      margin-top: 0;
      font-weight: normal;
    }
    .status {
      font-size: 1.4em;
      margin: 20px 0 10px;
    }
    button {
      font-size: 1.2em;
      padding: 10px 25px;
      border: none;
      border-radius: 6px;
      background-color: #3498db;
      color: white;
      cursor: pointer;
      margin-bottom: 20px;
    }
    button:hover {
      background-color: #2980b9;
    }
  </style>
</head>
<body>
  <h1>QUAD ROBOTICS</h1>
  <h4>A unit of Quad Store</h4>

  <div class="status">Relay 1 is <span id="r1">%STATE1%</span></div>
  <button onclick="toggleRelay(1)">Toggle Relay 1</button>

  <div class="status">Relay 2 is <span id="r2">%STATE2%</span></div>
  <button onclick="toggleRelay(2)">Toggle Relay 2</button>

  <script>
    function toggleRelay(relay) {
      fetch("/toggle?relay=" + relay)
        .then(response => response.text())
        .then(data => {
          let state = JSON.parse(data);
          document.getElementById("r1").innerText = state.relay1;
          document.getElementById("r2").innerText = state.relay2;
        });
    }
  </script>
</body>
</html>
)rawliteral";

// Replace placeholder with current state
String processor(const String& var) {
  if (var == "STATE1") return relay1State ? "ON" : "OFF";
  if (var == "STATE2") return relay2State ? "ON" : "OFF";
  return "";
}

void setup() {
  Serial.begin(115200);
  pinMode(RELAY1, OUTPUT);
  pinMode(RELAY2, OUTPUT);
  digitalWrite(RELAY1, HIGH); // relay OFF
  digitalWrite(RELAY2, HIGH);

  // Connect to Wi-Fi
  WiFi.begin(ssid, password);
  Serial.print("Connecting");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nConnected to WiFi!");
  Serial.println(WiFi.localIP());

  // Serve HTML page
  server.on("/", HTTP_GET, []() {
    String html = index_html;
    html.replace("%STATE1%", relay1State ? "ON" : "OFF");
    html.replace("%STATE2%", relay2State ? "ON" : "OFF");
    server.send(200, "text/html", html);
  });

  // Handle toggle
  server.on("/toggle", HTTP_GET, []() {
    if (server.hasArg("relay")) {
      int relay = server.arg("relay").toInt();
      if (relay == 1) {
        relay1State = !relay1State;
        digitalWrite(RELAY1, relay1State ? LOW : HIGH);
      } else if (relay == 2) {
        relay2State = !relay2State;
        digitalWrite(RELAY2, relay2State ? LOW : HIGH);
      }
    }
    String response = "{\"relay1\":\"" + String(relay1State ? "ON" : "OFF") + "\",\"relay2\":\"" + String(relay2State ? "ON" : "OFF") + "\"}";
    server.send(200, "application/json", response);
  });

  server.begin();
}

void loop() {
  server.handleClient();
}
