#include <WiFi.h>

const char* ssid = " YOUR_SSID";         // Replace with your WiFi Username
const char* password = " YOUR_PASSWORD"; // Replace with your WiFi password

WiFiServer server(80);
bool ledState = false;

void setup() {
  Serial.begin(115200);
  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);

  WiFi.begin(ssid, password);
  Serial.print("Connecting to WiFi");
  while (WiFi.status() != WL_CONNECTED) {
    delay(300);
    Serial.print(".");
  }

  Serial.println("\nConnected. IP:");
  Serial.println(WiFi.localIP());

  server.begin();
}

void loop() {
  WiFiClient client = server.available();
  if (!client) return;

  String request = "";
  while (client.connected()) {
    if (client.available()) {
      char c = client.read();
      request += c;

      if (c == '\n') {
        // Handle toggle requests
        if (request.indexOf("GET /toggle?state=1") != -1) {
          ledState = true;
          digitalWrite(LED_BUILTIN, HIGH);
        }
        if (request.indexOf("GET /toggle?state=0") != -1) {
          ledState = false;
          digitalWrite(LED_BUILTIN, LOW);
        }

        // Send HTML page
        if (request.indexOf("GET /toggle") == -1) {
          client.println("HTTP/1.1 200 OK");
          client.println("Content-Type: text/html");
          client.println("Connection: close");
          client.println();
          client.println("<!DOCTYPE html><html><head><meta name='viewport' content='width=device-width, initial-scale=1'>");
          client.println("<title>ESP32 Toggle LED</title>");
          client.println("<style>");
          client.println("body{font-family:sans-serif;text-align:center;padding-top:40px;}");
          client.println("h1{margin-bottom:5px;} p{margin-top:0;color:gray;}");
          client.println(".switch{position:relative;display:inline-block;width:60px;height:34px;}");
          client.println(".switch input{display:none;}");
          client.println(".slider{position:absolute;cursor:pointer;top:0;left:0;right:0;bottom:0;background-color:#ccc;transition:.4s;}");
          client.println(".slider:before{position:absolute;content:'';height:26px;width:26px;left:4px;bottom:4px;background-color:white;transition:.4s;}");
          client.println("input:checked + .slider{background-color:#2196F3;}");
          client.println("input:checked + .slider:before{transform:translateX(26px);}");
          client.println(".slider.round{border-radius:34px;}");
          client.println(".slider.round:before{border-radius:50%;}");
          client.println("</style>");
          client.println("</head><body>");

          client.println("<h1>QUAD ROBOTICS</h1>");
          client.println("<p>A unit of Quad Store</p>");
          client.println("<h2>Smart Web Controlled LED</h2>");

          client.println("<div style='display:inline-block;'>");
          client.print("<label class='switch'><input type='checkbox' onchange='toggleLED(this)' ");
          if (ledState) client.print("checked");
          client.println("><span class='slider round'></span></label>");
          client.println("<div style='display:flex; justify-content:space-between; margin-top:5px;'>");
          client.println("<span style='width:60px; text-align:left;'>OFF</span>");
          client.println("<span style='width:60px; text-align:right;'>ON</span>");
          client.println("</div></div>");

          client.println("<script>function toggleLED(element){");
          client.println("var xhr=new XMLHttpRequest();");
          client.println("xhr.open('GET','/toggle?state='+(element.checked?1:0),true);");
          client.println("xhr.send();");
          client.println("}</script>");
          client.println("</body></html>");
        } else {
          client.println("HTTP/1.1 200 OK");
          client.println("Content-Type: text/plain");
          client.println("Connection: close");
          client.println();
          client.println("OK");
        }
        break;
      }
    }
  }

  delay(1);
  client.stop();
}
