// IR scanner (IRremote v4.x+)
#include <IRremote.h>

const int RECV_PIN = 2;

void setup() {
  Serial.begin(9600);
  while(!Serial);
  Serial.println("IR scanner ready - press a button");
  IrReceiver.begin(RECV_PIN, ENABLE_LED_FEEDBACK); // initialize
}

void loop() {
  if (IrReceiver.decode()) {
    // print the value in HEX (works for NEC/most remotes)
    Serial.print("HEX: 0x");
    Serial.println(IrReceiver.decodedIRData.decodedRawData, HEX);
    // If decodedIRData contains .command or .value you can print that too:
    // Serial.println(IrReceiver.decodedIRData.command, HEX);
    IrReceiver.resume(); // ready for next value
  }
}
