// Pin connections for each segment
int a = 2;
int b = 3;
int c = 4;
int d = 5;
int e = 6;
int f = 7;
int g = 8;
int dp = 9;

// Array of segments for easy looping
int segments[] = {a, b, c, d, e, f, g};

void setup() {
  // Set all segment pins as outputs
  for (int i = 0; i < 7; i++) {
    pinMode(segments[i], OUTPUT);
  }
  pinMode(dp, OUTPUT);
}

void displayDigit(int digit) {
  // Segment patterns for digits 0–9 (common cathode)
  const byte numbers[10][7] = {
    // a b c d e f g
    {1,1,1,1,1,1,0},  // 0
    {0,1,1,0,0,0,0},  // 1
    {1,1,0,1,1,0,1},  // 2
    {1,1,1,1,0,0,1},  // 3
    {0,1,1,0,0,1,1},  // 4
    {1,0,1,1,0,1,1},  // 5
    {1,0,1,1,1,1,1},  // 6
    {1,1,1,0,0,0,0},  // 7
    {1,1,1,1,1,1,1},  // 8
    {1,1,1,1,0,1,1}   // 9
  };

  // Write segment values
  for (int i = 0; i < 7; i++) {
    digitalWrite(segments[i], numbers[digit][i]);
  }
}

void loop() {
  for (int i = 0; i < 10; i++) {
    displayDigit(i);
    delay(1000);   // show each number for 1 second
  }
}
