#include <Stepper.h>

const int STEPS_PER_REV = 2048;   // 28BYJ-48 full revolution steps

// Connect pin sequence IN1-IN3-IN2-IN4 or IN1-IN2-IN3-IN4
Stepper myStepper(STEPS_PER_REV, 8, 10, 9, 11);

void setup() {
  myStepper.setSpeed(12);  // speed in RPM (5–15 recommended)
  Serial.begin(9600);
  Serial.println("Stepper Test");
}

void loop() {
  Serial.println("Rotating Clockwise...");
  myStepper.step(2048);   // one full rotation clockwise
  delay(1000);

  Serial.println("Rotating Anti-Clockwise...");
  myStepper.step(-2048);  // one full rotation anticlockwise
  delay(1000);
}
